<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_users
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

// Create the copy/move options.
$options = array(
	JHtml::_('select.option', 'add', JText::_('COM_USERS_BATCH_ADD')),
	JHtml::_('select.option', 'del', JText::_('COM_USERS_BATCH_DELETE')),
	JHtml::_('select.option', 'set', JText::_('COM_USERS_BATCH_SET'))
);
JHtml::_('formbehavior.chosen', 'select');
?>
<div class="modal hide fade" id="collapseModal">
	<div class="modal-header">
		<button type="button" class="close" data-dismiss="modal">x</button>
		<h3><?php echo JText::_('COM_USERS_BATCH_OPTIONS');?></h3>
	</div>
	<div class="modal-body">
		<div id="batch-choose-action" class="combo control-group">
			<label id="batch-choose-action-lbl" class="control-label" for="batch-choose-action">
				<?php echo JText::_('COM_USERS_BATCH_GROUP') ?>
			</label>
		</div>
		<div id="batch-choose-action" class="combo controls">
			<div class="control-group">
				<select name="batch[group_id]" class="inputbox" id="batch-group-id">
					<option value=""><?php echo JText::_('JSELECT') ?></option>
					<?php echo JHtml::_('select.options', JHtml::_('user.groups')); ?>
				</select>
			</div>
		</div>
		<div class="control-group radio">
			<?php echo JHtml::_('select.radiolist', $options, 'batch[group_action]', '', 'value', 'text', 'add') ?>
		</div>
	</div>
	<div class="modal-footer">
		<button class="btn" type="button" onclick="document.id('batch-group-id').value=''" data-dismiss="modal">
			<?php echo JText::_('JCANCEL'); ?>
		</button>
		<button class="btn btn-primary" type="submit" onclick="Joomla.submitbutton('user.batch');">
			<?php echo JText::_('JGLOBAL_BATCH_PROCESS'); ?>
		</button>
	</div>
</div>
